<?php
/**
 * NOTICE OF LICENSE.
 *
 * CLF for PrestaShop is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/afl-3.0.php
 *
 * @author    SARL KIXELL (https://kixell.fr)
 * @copyright Copyright © 2021 - SARL Kixell
 * @license   https://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 *
 * @version   1.0.3
 */
require_once _PS_MODULE_DIR_.'/clfpayment/src/Classes/CLFLogger.php';
require_once _PS_MODULE_DIR_.'/clfpayment/src/Classes/CLFTools.php';

/**
 * Class CLFValidationModuleFrontController.
 */
class CLFConfirmationModuleFrontController extends ModuleFrontController
{
    public $ssl = true;

    public function __construct()
    {
        $this->ajax = Tools::getIsset('ajax') && Tools::getValue('ajax') ? true : false;
        $this->display_column_left = false;
        $this->display_column_right = version_compare(_PS_VERSION_, '1.6', '<');
        parent::__construct();
    }

    public function initHeader()
    {
        parent::initHeader();
        session_cache_limiter('private_no_expire');
        header('Cache-Control: post-check=0, pre-check=0', false);
        header('Cache-Control: no-store, no-cache, must-revalidate');
        header('Pragma: no-cache');
    }

    /**
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public function postProcess()
    {
        $CLF_elapsed_time = 10;
        if ($this->ajax && Tools::getIsset('elapsed')) {
            $CLF_elapsed_time = (int) Tools::getValue('elapsed') - 1;
        }

        CLFLogger::logInfo('[confirmation] postProcess called');
        if ($CLF_elapsed_time > 0 && Tools::getIsset('cart_id')) {
            $cart_id = Tools::getValue('cart_id');
            $cart = new Cart((int) $cart_id);
            CLFLogger::logInfo('[confirmation] $cart_id = '.$cart_id);
            if (Validate::isLoadedObject($cart)) {
                $order_id = Order::getOrderByCartId($cart_id);
                $order = new Order((int) $order_id);
                CLFLogger::logInfo('[confirmation] $order_id = '.$order_id);
                if (Validate::isLoadedObject($order)) {
                    CLFLogger::logInfo('[confirmation] redirect order confirmation');
                    // Redirect to order confirmation
                    $query = [
                        'id_cart'   => (int) $cart->id,
                        'id_module' => (int) $this->module->id,
                        'id_order'  => (int) $order->id,
                        'key'       => $order->secure_key,
                    ];
                    $page = CLFTools::CLFPageLink('order-confirmation', $query);
                    CLFTools::CLFRedirect($page, $this->ajax);
                } else { // Webhook still not called or in progress
                    CLFLogger::logInfo('[confirmation] Order not loaded, cart_id : '.$cart_id).', start waiting ... ';

                    if ($this->ajax) {
                        ob_end_clean();
                        header('Content-Type: application/json');
                        exit(json_encode([
                            'elapsed' => $CLF_elapsed_time,
                        ]));
                    } else {
                        $ajax_call = Context::getContext()->link->getModuleLink(
                            'CLF',
                            'confirmation',
                            ['ajax' => true, 'cart_id' => $cart->id, 'elapsed' => $CLF_elapsed_time],
                            true
                        );
                        $CLF_default_url_redirect = CLFTools::CLFPageLink('history');
                        $smarty_vars = [
                            'CLF_elapsed_time_url'     => base64_encode($ajax_call),
                            'CLF_default_url_redirect' => base64_encode($CLF_default_url_redirect),
                            'CLF_elapsed_time'         => $CLF_elapsed_time,
                        ];
                        $this->context->smarty->assign($smarty_vars);
                        if (version_compare(_PS_VERSION_, '1.7', '>=')) {
                            $this->setTemplate('module:CLF/views/templates/front/confirmation-1.7.tpl');
                        } else {
                            $this->setTemplate('confirmation-1.6.tpl');
                        }
                    }
                }
            } else {
                CLFLogger::logError('[confirmation] Cart not loaded properly, cart id : '.$cart_id);
                $page = CLFTools::CLFPageLink('history');
                CLFTools::CLFRedirect($page);
            }
        } else {
            CLFLogger::logError('[confirmation] cart_id does not exist');
            $page = CLFTools::CLFPageLink('history');
            CLFTools::CLFRedirect($page);
        }
    }
}
