<?php
/**
 * Plugin Name: Clever Finance Payment 
 * Description: A WooCommerce payment gateway integration for Clever Finance.
 * Version: 1.0.0
 * Author: Clever Finance
 * License: GPL v2 or later
 * WC requires at least: 5.0
 * WC tested up to: 8.0
 */
namespace CLF;
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// Define plugin constants
define('CLEVER_FINANCE_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('CLEVER_FINANCE_PLUGIN_URL', plugin_dir_url(__FILE__));

define( 'PLUGIN_NAME', 'clever_finance' );
define( 'CLF_PLUGIN_NAME', 'clever_finance' );

define( 'PLUGIN_VERSION', '1.0.0' );
define( 'CLF_VERSION', '1.0.0' );

define( 'PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

define( 'PLUGIN_TEXT_DOMAIN', 'clever_finance' );
define( 'CLF_PLUGIN_TEXT_DOMAIN', 'clever_finance' );

defined('WPINC') || die;

require_once( CLEVER_FINANCE_PLUGIN_PATH . 'inc/libraries/autoloader.php' );

// Include required files
require_once CLEVER_FINANCE_PLUGIN_PATH . 'includes/class-clever-finance-api.php';
require_once CLEVER_FINANCE_PLUGIN_PATH . 'includes/class-clever-finance-webhook.php';
require_once CLEVER_FINANCE_PLUGIN_PATH . 'inc/admin/class-clever-finance-admin.php';

/**
 * Register Activation and Deactivation Hooks
 * This action is documented in inc/core/class-activator.php
 */

 register_activation_hook( __FILE__, array( 'CLF\Inc\Core\Activator', 'activate' ) );

 /**
  * The code that runs during plugin deactivation.
  * This action is documented inc/core/class-deactivator.php
  */
 
 register_deactivation_hook( __FILE__, array( 'CLF\Inc\Core\Deactivator', 'deactivate' ) );

class CleverFinance {

	/**
	 * The instance of the plugin.
	 *
	 * @since    1.0.0
	 * @var      Init $init Instance of the plugin.
	 */
	private static $init;
	/**
	 * Loads the plugin
	 *
	 * @access    public
	 */
	public static function init() {

		if ( null === self::$init ) {
			self::$init = new Inc\Core\Init();
			self::$init->run();
		}

		return self::$init;
	}

}
function clever_finance_enqueue_styles($hook) {
    if ($hook !== 'woocommerce_page_clever-finance-settings') {
        return;
    }
    wp_enqueue_style(
        'spectre-css',
        plugin_dir_url(__FILE__) . 'assets/libs/spectre.min.css',
        array(),
        '0.5.9', 
        'all'
    );

    wp_enqueue_style(
        'clever-finance-style',
        plugin_dir_url(__FILE__) . 'assets/css/admin-style.css',
        array('spectre-css'),
        '1.0',
        'all'
    );
}
// Initialize plugin
function clever_finance_init() {
   return CleverFinance::init();
}

$min_php = '5.6.0';
add_action('admin_enqueue_scripts', __NAMESPACE__ . '\\clever_finance_enqueue_styles');
// Check the minimum required PHP version and run the plugin.
if ( version_compare( PHP_VERSION, $min_php, '>=' ) ) {
	clever_finance_init();
}

