<?php

namespace CLF\Inc\Common;

use CLF\Inc\Common\PaymentMethods\Bancontact;
use CLF\Inc\Common\PaymentMethods\Carte_Bleue;
use CLF\Inc\Common\PaymentMethods\CLF_Standard;
use CLF\Inc\Common\PaymentMethods\Digiteal_Direct;
use CLF\Inc\Common\PaymentMethods\Ideal;
use CLF\Inc\Common\PaymentMethods\Maestro;
use CLF\Inc\Common\PaymentMethods\Mastercard;
use CLF\Inc\Common\PaymentMethods\Payconiq;
use CLF\Inc\Common\PaymentMethods\PIS_Standard;
use CLF\Inc\Common\PaymentMethods\Visa;

class Gateways
{
    const GATEWAYS = [
        'clever_finance_bancontact'           => Bancontact::class,
        'clever_finance_carte_bleue'          => Carte_Bleue::class,
        'clever_finance_digiteal_direct'      => Digiteal_Direct::class,
        'clever_finance_digiteal_standard'    => CLF_Standard::class,
        'clever_finance_ideal'                => Ideal::class,
        'clever_finance_maestro'              => Maestro::class,
        'clever_finance_mastercard'           => Mastercard::class,
        'clever_finance_payconiq'             => Payconiq::class,
        'clever_finance_pis_standard'         => PIS_Standard::class,
        'clever_finance_visa'                 => Visa::class,
    ];

    public static function getGateways()
    {
        // Get the plugin name constant
        $plugin_name = PLUGIN_NAME;

        // Get the settings
        $settings = get_option( 'clever_finance_options' );

        // If the available_payment_methods are not set or empty, return all the gateways
        if ( ! isset( $settings['available_payment_methods'] ) || empty( $settings['available_payment_methods'] ) ) {
            return self::GATEWAYS;
        }

        // Get the available payment methods
        $available_payment_methods = $settings['available_payment_methods'];

        // Filter and return the gateways
        return array_filter( self::GATEWAYS, function ( $gateway ) use ( $available_payment_methods ) {
            return in_array( (new $gateway())->get_payment_method_code(), $available_payment_methods );
        } );
    }
}
